/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.math;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.math.MathUtils;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.FriendlyByteBuf;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FloatingLong
extends Number
implements Comparable<FloatingLong> {
    private static final DecimalFormat df = new DecimalFormat("0.0000", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private static final int DECIMAL_DIGITS = 4;
    private static final short MAX_DECIMAL = 9999;
    private static final short SINGLE_UNIT = 10000;
    private static final long MAX_LONG_SHIFT = Long.divideUnsigned(Long.divideUnsigned(-1L, 10000L), 10000L);
    public static final FloatingLong ZERO = FloatingLong.createConst(0L);
    public static final FloatingLong ONE = FloatingLong.createConst(1L);
    public static final FloatingLong MAX_VALUE = FloatingLong.createConst(-1L, (short)9999);
    private static final double MAX_AS_DOUBLE = Double.parseDouble(MAX_VALUE.toString());
    private final boolean isConstant;
    private long value;
    private short decimal;

    public static FloatingLong create(double value) {
        if (value > MAX_AS_DOUBLE) {
            return MAX_VALUE;
        }
        if (value < 0.0) {
            return ZERO;
        }
        long lValue = (long)value;
        short decimal = FloatingLong.parseDecimal(df.format(value));
        return FloatingLong.create(lValue, decimal);
    }

    public static FloatingLong create(long value) {
        return FloatingLong.create(value, (short)0);
    }

    public static FloatingLong create(long value, short decimal) {
        return new FloatingLong(value, decimal, false);
    }

    public static FloatingLong createConst(double value) {
        if (value > MAX_AS_DOUBLE) {
            return MAX_VALUE;
        }
        if (value < 0.0) {
            return ZERO;
        }
        long lValue = (long)value;
        short decimal = FloatingLong.parseDecimal(df.format(value));
        return FloatingLong.createConst(lValue, decimal);
    }

    public static FloatingLong createConst(long value) {
        return FloatingLong.createConst(value, (short)0);
    }

    public static FloatingLong createConst(long value, short decimal) {
        return new FloatingLong(value, decimal, true);
    }

    public static FloatingLong readFromBuffer(FriendlyByteBuf buffer) {
        return new FloatingLong(buffer.m_130258_(), buffer.readShort(), false);
    }

    private FloatingLong(long value, short decimal, boolean isConstant) {
        this.setAndClampValues(value, decimal);
        this.isConstant = isConstant;
    }

    public long getValue() {
        return this.value;
    }

    public short getDecimal() {
        return this.decimal;
    }

    private FloatingLong setAndClampValues(long value, short decimal) {
        if (decimal < 0) {
            decimal = 0;
        } else if (decimal > 9999) {
            decimal = (short)9999;
        }
        if (this.isConstant) {
            return FloatingLong.create(value, decimal);
        }
        this.value = value;
        this.decimal = decimal;
        return this;
    }

    public boolean isZero() {
        return this.value == 0L && this.decimal <= 0;
    }

    public FloatingLong copy() {
        return new FloatingLong(this.value, this.decimal, false);
    }

    public FloatingLong copyAsConst() {
        return this.isConstant ? this : new FloatingLong(this.value, this.decimal, true);
    }

    public FloatingLong plusEqual(FloatingLong toAdd) {
        if (this.value < 0L && toAdd.value < 0L || (this.value < 0L || toAdd.value < 0L) && this.value + toAdd.value >= 0L) {
            return this.setAndClampValues(-1L, (short)9999);
        }
        long newValue = this.value + toAdd.value;
        int newDecimal = this.decimal + toAdd.decimal;
        if (newDecimal > 9999) {
            if (newValue == -1L) {
                newDecimal = 9999;
            } else {
                newDecimal = (short)(newDecimal - 10000);
                ++newValue;
            }
        }
        return this.setAndClampValues(newValue, (short)newDecimal);
    }

    public FloatingLong minusEqual(FloatingLong toSubtract) {
        if (toSubtract.greaterThan(this)) {
            return this.setAndClampValues(0L, (short)0);
        }
        long newValue = this.value - toSubtract.value;
        short newDecimal = (short)(this.decimal - toSubtract.decimal);
        if (newDecimal < 0) {
            newDecimal = (short)(newDecimal + 10000);
            --newValue;
        }
        return this.setAndClampValues(newValue, newDecimal);
    }

    public FloatingLong timesEqual(FloatingLong toMultiply) {
        if (FloatingLong.multiplyLongsWillOverFlow(this.value, toMultiply.value)) {
            return MAX_VALUE;
        }
        FloatingLong temp = FloatingLong.create(FloatingLong.multiplyLongs(this.value, toMultiply.value));
        temp = temp.plusEqual(FloatingLong.multiplyLongAndDecimal(this.value, toMultiply.decimal));
        temp = temp.plusEqual(FloatingLong.multiplyLongAndDecimal(toMultiply.value, this.decimal));
        temp = temp.plusEqual(FloatingLong.multiplyDecimals(this.decimal, toMultiply.decimal));
        return this.setAndClampValues(temp.value, temp.decimal);
    }

    public FloatingLong divideEquals(FloatingLong toDivide) {
        if (toDivide.isZero()) {
            throw new ArithmeticException("Division by zero");
        }
        if (this.isZero()) {
            return ZERO;
        }
        if (toDivide.decimal == 0) {
            return this.divideEquals(toDivide.value);
        }
        BigDecimal divide = new BigDecimal(this.toString()).divide(new BigDecimal(toDivide.toString()), 4, RoundingMode.HALF_UP);
        long value = divide.longValue();
        short decimal = FloatingLong.parseDecimal(divide.toPlainString());
        return this.setAndClampValues(value, decimal);
    }

    public FloatingLong divideEquals(long toDivide) {
        long dec;
        if (toDivide == 0L) {
            throw new ArithmeticException("Division by zero");
        }
        if (this.isZero()) {
            return ZERO;
        }
        long val = Long.divideUnsigned(this.value, toDivide);
        long rem = Long.remainderUnsigned(this.value, toDivide);
        if (Long.compareUnsigned(rem, MAX_LONG_SHIFT / 10L) >= 0) {
            dec = Long.divideUnsigned(rem, Long.divideUnsigned(toDivide, 100000L));
        } else {
            dec = Long.divideUnsigned(rem * 10000L * 10L, toDivide);
            dec += Long.divideUnsigned((long)this.decimal * 10L, toDivide);
        }
        if (Long.remainderUnsigned(dec, 10L) >= 5L && (dec += 10L) >= 100000L) {
            ++val;
            dec -= 100000L;
        }
        return this.setAndClampValues(val, (short)(dec /= 10L));
    }

    public long divideToUnsignedLong(FloatingLong toDivide) {
        if (toDivide.isZero()) {
            throw new ArithmeticException("Division by zero");
        }
        if (this.smallerThan(toDivide)) {
            return 0L;
        }
        if (toDivide.greaterOrEqual(ONE)) {
            if (Long.compareUnsigned(toDivide.value, MAX_LONG_SHIFT) <= 0) {
                long div = toDivide.value * 10000L + (long)toDivide.decimal;
                return Long.divideUnsigned(this.value, div) * 10000L + Long.divideUnsigned(Long.remainderUnsigned(this.value, div) * 10000L, div);
            }
            if (Long.compareUnsigned(toDivide.value, Long.divideUnsigned(-1L, 2L) + 1L) >= 0) {
                return 1L;
            }
            long q = Long.divideUnsigned(this.value, toDivide.value);
            if (q != Long.divideUnsigned(this.value, toDivide.value + 1L) && toDivide.value * q + Long.divideUnsigned((long)toDivide.decimal * q, 9999L) > this.value) {
                return q - 1L;
            }
            return q;
        }
        if (Long.compareUnsigned(this.value, MAX_LONG_SHIFT) >= 0) {
            return Long.divideUnsigned(this.value, toDivide.decimal) * 9999L + Long.divideUnsigned(Long.remainderUnsigned(this.value, toDivide.decimal) * 9999L, toDivide.decimal) + (long)this.decimal * 9999L / (long)toDivide.decimal;
        }
        long d = this.value * 9999L;
        return Long.divideUnsigned(d, toDivide.decimal) + (long)this.decimal * 9999L / (long)toDivide.decimal;
    }

    public long divideToLong(FloatingLong toDivide) {
        return MathUtils.clampUnsignedToLong(this.divideToUnsignedLong(toDivide));
    }

    public int divideToInt(FloatingLong toDivide) {
        return MathUtils.clampUnsignedToInt(this.divideToLong(toDivide));
    }

    public FloatingLong add(FloatingLong toAdd) {
        return this.copy().plusEqual(toAdd);
    }

    public FloatingLong add(long toAdd) {
        return this.add(FloatingLong.create(toAdd));
    }

    public FloatingLong add(double toAdd) {
        if (toAdd < 0.0) {
            throw new IllegalArgumentException("Addition called with negative number, this is not supported. FloatingLongs are always positive.");
        }
        return this.add(FloatingLong.create(toAdd));
    }

    public FloatingLong subtract(FloatingLong toSubtract) {
        return this.copy().minusEqual(toSubtract);
    }

    public FloatingLong subtract(long toSubtract) {
        return this.subtract(FloatingLong.create(toSubtract));
    }

    public FloatingLong subtract(double toSubtract) {
        if (toSubtract < 0.0) {
            throw new IllegalArgumentException("Subtraction called with negative number, this is not supported. FloatingLongs are always positive.");
        }
        return this.subtract(FloatingLong.create(toSubtract));
    }

    public FloatingLong multiply(FloatingLong toMultiply) {
        return this.copy().timesEqual(toMultiply);
    }

    public FloatingLong multiply(long toMultiply) {
        return this.multiply(FloatingLong.create(toMultiply));
    }

    public FloatingLong multiply(double toMultiply) {
        if (toMultiply < 0.0) {
            throw new IllegalArgumentException("Multiply called with negative number, this is not supported. FloatingLongs are always positive.");
        }
        return this.multiply(FloatingLong.createConst(toMultiply));
    }

    public FloatingLong divide(FloatingLong toDivide) {
        return this.copy().divideEquals(toDivide);
    }

    public FloatingLong divide(long toDivide) {
        return this.copy().divideEquals(toDivide);
    }

    public FloatingLong divide(double toDivide) {
        if (toDivide < 0.0) {
            throw new IllegalArgumentException("Division called with negative number, this is not supported. FloatingLongs are always positive.");
        }
        return this.divide(FloatingLong.create(toDivide));
    }

    public double divideToLevel(FloatingLong toDivide) {
        return toDivide.isZero() || this.greaterThan(toDivide) ? 1.0 : this.divide(toDivide).doubleValue();
    }

    public FloatingLong max(FloatingLong other) {
        return this.smallerThan(other) ? other : this;
    }

    public FloatingLong min(FloatingLong other) {
        return this.greaterThan(other) ? other : this;
    }

    public FloatingLong ceil() {
        if (this.decimal == 0) {
            return this;
        }
        if (this.value == -1L) {
            return new FloatingLong(this.value, 0, false);
        }
        return new FloatingLong(this.value + 1L, 0, false);
    }

    public FloatingLong floor() {
        return this.decimal == 0 ? this : new FloatingLong(this.value, 0, false);
    }

    public boolean smallerThan(FloatingLong toCompare) {
        return this.compareTo(toCompare) < 0;
    }

    public boolean smallerOrEqual(FloatingLong toCompare) {
        return this.compareTo(toCompare) <= 0;
    }

    public boolean greaterThan(FloatingLong toCompare) {
        return this.compareTo(toCompare) > 0;
    }

    public boolean greaterOrEqual(FloatingLong toCompare) {
        return this.compareTo(toCompare) >= 0;
    }

    @Override
    public int compareTo(FloatingLong toCompare) {
        int valueCompare = Long.compareUnsigned(this.value, toCompare.value);
        if (valueCompare == 0) {
            if (this.decimal < toCompare.decimal) {
                return -2;
            }
            if (this.decimal > toCompare.decimal) {
                return 2;
            }
            return 0;
        }
        return valueCompare;
    }

    public boolean equals(FloatingLong other) {
        return this.value == other.value && this.decimal == other.decimal;
    }

    public boolean equals(Object o) {
        FloatingLong other;
        return this == o || o instanceof FloatingLong && this.equals(other = (FloatingLong)o);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.decimal);
    }

    @Override
    public byte byteValue() {
        int v = this.intValue();
        if (v < 127) {
            return (byte)v;
        }
        return 127;
    }

    @Override
    public short shortValue() {
        int v = this.intValue();
        if (v < Short.MAX_VALUE) {
            return (short)v;
        }
        return Short.MAX_VALUE;
    }

    @Override
    public int intValue() {
        return MathUtils.clampUnsignedToInt(this.value);
    }

    @Override
    public long longValue() {
        return MathUtils.clampUnsignedToLong(this.value);
    }

    @Override
    public float floatValue() {
        return MathUtils.unsignedLongToFloat(this.value) + (float)this.decimal / 10000.0f;
    }

    @Override
    public double doubleValue() {
        return MathUtils.unsignedLongToDouble(this.value) + (double)this.decimal / 10000.0;
    }

    public FloatingLong absDifference(FloatingLong other) {
        if (this.greaterThan(other)) {
            return this.subtract(other);
        }
        return this.add(other);
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.m_130103_(this.value);
        buffer.writeShort((int)this.decimal);
    }

    public String toString() {
        return this.toString(4);
    }

    public String toString(int decimalPlaces) {
        if (this.decimal == 0) {
            return Long.toUnsignedString(this.value);
        }
        if (decimalPlaces > 4) {
            decimalPlaces = 4;
        }
        String valueAsString = Long.toUnsignedString(this.value) + ".";
        Object decimalAsString = Short.toString(this.decimal);
        int numberDigits = ((String)decimalAsString).length();
        if (numberDigits < 4) {
            decimalAsString = FloatingLong.getZeros(4 - numberDigits) + (String)decimalAsString;
            numberDigits = 4;
        }
        if (numberDigits > decimalPlaces) {
            decimalAsString = ((String)decimalAsString).substring(0, decimalPlaces);
        }
        return valueAsString + (String)decimalAsString;
    }

    public static FloatingLong parseFloatingLong(String string) {
        return FloatingLong.parseFloatingLong(string, false);
    }

    public static FloatingLong parseFloatingLong(String string, boolean isConstant) {
        int index = string.indexOf(46);
        long value = index == -1 ? Long.parseUnsignedLong(string) : Long.parseUnsignedLong(string.substring(0, index));
        short decimal = FloatingLong.parseDecimal(string, index);
        return isConstant ? FloatingLong.createConst(value, decimal) : FloatingLong.create(value, decimal);
    }

    private static short parseDecimal(String string) {
        return FloatingLong.parseDecimal(string, string.indexOf(46));
    }

    private static short parseDecimal(String string, int index) {
        if (index == -1) {
            return 0;
        }
        Object decimalAsString = string.substring(index + 1);
        int numberDigits = ((String)decimalAsString).length();
        if (numberDigits < 4) {
            decimalAsString = (String)decimalAsString + FloatingLong.getZeros(4 - numberDigits);
        } else if (numberDigits > 4) {
            decimalAsString = ((String)decimalAsString).substring(0, 4);
        }
        return Short.parseShort((String)decimalAsString);
    }

    private static String getZeros(int number) {
        return "0".repeat(Math.max(0, number));
    }

    private static boolean multiplyLongsWillOverFlow(long a, long b) {
        return a != 0L && b != 0L && Long.compareUnsigned(b, Long.divideUnsigned(-1L, a)) > 0;
    }

    private static long multiplyLongs(long a, long b) {
        if (a == 0L || b == 0L) {
            return 0L;
        }
        if (FloatingLong.multiplyLongsWillOverFlow(a, b)) {
            return -1L;
        }
        return a * b;
    }

    private static FloatingLong multiplyLongAndDecimal(long value, short decimal) {
        if (Long.compareUnsigned(value, Long.divideUnsigned(-1L, 10000L)) > 0) {
            return FloatingLong.create(Long.divideUnsigned(value, 10000L) * (long)decimal, (short)(value % 10000L * (long)decimal));
        }
        return FloatingLong.create(Long.divideUnsigned(value * (long)decimal, 10000L), (short)(value * (long)decimal % 10000L));
    }

    private static FloatingLong multiplyDecimals(short a, short b) {
        long temp = (long)a * (long)b / 10000L;
        return FloatingLong.create(0L, (short)temp);
    }
}

